﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="ReferralContactLog.aspx.cs" Inherits="ReferralContactLog" MasterPageFile = "~/Registry.master" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href = "styles/StyleSheet.css" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <%--<script type = "text/javascript">
        function Validate()
        {
            alert("Contact log entry will be deleted.");
            return true;
        }    
    
    </script>  --%>
    
    <asp:ObjectDataSource ID="ObjectDataSourcePatient" runat="server" 
        SelectMethod="GetPatientByReferralId" 
        TypeName="VeteransAffairs.Registries.BusinessManager.ReferralManager">
        <SelectParameters>
            <asp:QueryStringParameter QueryStringField = "referralId" Direction = "Input" Name = "id" /> 
        </SelectParameters>       
    </asp:ObjectDataSource>
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "BreadCrumbLabel" runat="server"  
            Text= "My Tasks > Contact Logs > All Contacts > Referral # "  />
    </div>    
    <asp:FormView ID="FormViewPatientInformation" runat="server"  
        DataSourceID="ObjectDataSourcePatient" 
        Width="79%" 
        DataKeyNames = "PATIENT_ID" 
        Visible = "true">
    <FooterStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" />
    <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
    <ItemTemplate>
        <asp:Panel ID="PanelPatient" runat="server" GroupingText="Patient" Width="100%">
            <table cellpadding="-1" cellspacing="-1" width="100%">
                <tr style = "height:20px;" >
                    <td style="width:20px;">
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelICN" runat="server" Text="ICN:" AssociatedControlID="VPIDLabel"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID="VPIDLabel" runat="server"  Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PATIENT_ICN")), false) %>' />
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelName" runat="server" Text="Name:" AssociatedControlID="NameLabel"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID="NameLabel" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAST_NAME")), false)+ "," + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("FIRST_NAME")), false) + "&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("MIDDLE_NAME")), false)%>' />
                    </td>
                    <td >
                        <asp:Label SkinID="DataLabel" ID="LabelForSSN" runat="server" Text="SSN:" AssociatedControlID="LabelSSN"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID = "LabelSSN" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Snum")), false) %>'  />
                    </td>
                    <td>
                         <asp:Label SkinID="DataLabel" ID="LabelForPostal" runat="server" Text="Zip Code:" AssociatedControlID="LabelPostal"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID = "LabelPostal" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("POSTAL_CODE")), false) %>'  />
                    </td>
                   
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForDOB" runat="server" Text="DOB:" AssociatedControlID="LabelDOB"></asp:Label>
                        <asp:Label SkinID="DataLabel" ID = "LabelDOB" runat = "server"  Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("BIRTH_DATE", "{0:d}")),false) %>'/> 
                    </td>
                    <td>
                        &nbsp;
                    </td>
                    <td align = "left">
                    </td>
                </tr>
            </table>
    </asp:Panel>
    <br />   
     
    </ItemTemplate>
    </asp:FormView>
    <asp:Repeater ID = "EFRReferralChatLog" runat = "server"  
        DataSourceID = "ObjectDataSourceEFRRefrralContactLog"  
        OnItemCommand = "EFRReferralChatLog_ItemCommand" OnItemDataBound = "EFRReferralChatLog_DataBound">
        <HeaderTemplate>
        <table id="TableLabResults" cellspacing="-2" cellpadding="2">
            <tr>
                <td>
                    <asp:Button 
                        ID = "NewButton" 
                        runat = "server" 
                        Text = "New Contact" 
                        CommandName = "Add"/>
                    <asp:Button 
                        ID = "CancelButton" 
                        runat = "server" 
                        ToolTip="Click to go to previous screen"
                        Text = "Cancel" 
                        OnClick="CancelButton_OnClick"
                        UseSubmitBehavior="false"/>
                </td>   
                <td>
                    
                </td>          
            </tr>            
            <tr>
                <td colspan="2">
                    <hr style = "color:Black;"/> 
                </td>
            </tr>
            
        </HeaderTemplate> 
        <SeparatorTemplate >
            <tr>
                <td colspan="2">
                    <hr style = "color:Black; width:800px" /> 
                </td>
            </tr>
        </SeparatorTemplate> 
        <ItemTemplate>
            <tr>
                <td colspan = "2">
                    <asp:HiddenField ID="ContactIDField" runat="server" 
                        Value='<%# Eval("ContactId") %>' />
                    <asp:Label SkinID="DataLabel" ID = "ConversationHeader" runat = "server" 
                        Text = '<%# "Between&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ContactName")), false) + "&nbsp;and&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ContactInitiator")), false) + 
                        "&nbsp;on&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ContactDate")), false) %>'>
                    </asp:Label> 
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <asp:Label SkinID="DataLabel" ID = "ContactReason" runat = "server" 
                        Width="600px"
                        Text = '<%# "Reason:&nbsp;" + AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ContactReason")), false) %>'>
                    </asp:Label>
                </td> 
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <asp:Label SkinID="DataLabel" ID = "ContactText" runat = "server"  
                        Width="600px"
                        Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ContactText")), false) %>'>
                    </asp:Label>
                </td> 
            </tr>
            <tr>
                <td colspan="2">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td style = "width:50%" align = "left" >
                    <asp:Label SkinID="DataLabel" ID = "ContactComments" runat = "server" 
                       Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ContactComments")), false) %>'>
                    </asp:Label>
                </td> 
                <td style = "width:50%" align = "left">
                    <asp:Button ID = "SelectButton" runat = "server" Text = "Select" CommandName = "Details" Width = "70px" />
                    <asp:Button ID = "DeleteButton" runat = "server" OnClientClick="return confirm('Are you sure you want to delete this Contact log entry?');"
                         Text = "Delete" CommandName = "DeleteContact" Enabled= '<%# EnableButtton() %>' Width = "70px" /> 
                </td>
            </tr>
        </ItemTemplate>
        <FooterTemplate>
            <tr>
                <td colspan="2">
                    <hr style = "color:Black; width:800px" /> 
                </td>
            </tr>
        </table> 
        </FooterTemplate>
    </asp:Repeater> 
    <asp:ObjectDataSource ID="ObjectDataSourceEFRRefrralContactLog" runat="server"
        DataObjectTypeName = "VeteransAffairs.Registries.Business.CONTACT_LOG" 
        SelectMethod="SelectByID" 
        TypeName="VeteransAffairs.Registries.BusinessManager.ContactLogManager">
        <SelectParameters>
            <asp:QueryStringParameter QueryStringField = "referralId" Direction = "Input" Name = "id" /> 
        </SelectParameters>       
     </asp:ObjectDataSource>
</asp:Content> 
